﻿/// <reference name="MicrosoftAjax.js"/>


Type.registerNamespace("TextBoxInfoCompositeControl");

TextBoxInfoCompositeControl.TextBoxInfo = function(element) {
    TextBoxInfoCompositeControl.TextBoxInfo.initializeBase(this, [element]);
    this._textBoxElement;
    this._imageElement;
    this._informationText;
}

TextBoxInfoCompositeControl.TextBoxInfo.prototype = {
    initialize: function() {
        TextBoxInfoCompositeControl.TextBoxInfo.callBaseMethod(this, 'initialize');

        $addHandlers(this._imageElement,{"click":this._imageElementClickHandler},this);
    },
    get_informationText: function(){
        return this._informationText;
    },
    set_informationText: function(value){
        this._informationText = value;
    },
    get_textBoxElement: function(){
        this._textBoxElement;
    },
    set_textBoxElement: function(value){
        this._textBoxElement = value;
    },
    get_imageElement: function(){
        return this._imageElement;
    },
    set_imageElement: function(value){
        this._imageElement = value;
    },
    _imageElementClickHandler: function(e){
        alert(this._informationText);
    },
    dispose: function() {        
        // tutaj należy dodać niestandardowy kod zwalniający
        TextBoxInfoCompositeControl.TextBoxInfo.callBaseMethod(this, 'dispose');
    }
}
TextBoxInfoCompositeControl.TextBoxInfo.registerClass('TextBoxInfoCompositeControl.TextBoxInfo', Sys.UI.Control);

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();